/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml.strip;

import com.google.common.collect.Sets;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class ActivePartsParser {
    private final XMLReader reader;
    private final ShopConfiguration conf;
    private final Set<Material> usedMatprods;

    public ActivePartsParser(ShopConfiguration conf) {
        this.conf = conf;
        this.usedMatprods = Sets.newIdentityHashSet();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser parser = spf.newSAXParser();
            this.reader = parser.getXMLReader();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize the SAX parser.", e);
        }
        this.reader.setContentHandler(new ActivePartsHandler());
    }

    public void parse(InputStream inputStream) throws IOException, SAXException {
        this.usedMatprods.clear();
        this.reader.parse(new InputSource(inputStream));
    }

    public Set<Material> getUsedMatprods() {
        return Collections.unmodifiableSet(this.usedMatprods);
    }

    private class ActivePartsHandler
    extends DefaultHandler {
        private ActivePartsHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Material m3;
            int index = -1;
            if ("gor".equals(qName)) {
                index = attributes.getIndex("product");
            } else if ("request".equals(qName)) {
                index = attributes.getIndex("material");
            }
            if (index >= 0 && (m3 = ActivePartsParser.this.conf.getMatprod(attributes.getValue(index))) != null) {
                Product.collectMpRec(m3, ActivePartsParser.this.usedMatprods);
            }
        }
    }
}

